﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Xml.Xsl;

namespace PI.ZB.N1200.ELearning.BL.APIMobile.Model
{
    public class GExerciseData_Auxyliary : GExerciseData
    {
        public class ExerciseDataStub : IExerciseDataStub
        {
            public ExerciseDataStub()
            {

            }

            public int id { get; set; }
            public string text { get; set; }
            public long suggested_context_id { get; set; }
            public long suggested_course_id { get; set; }
        }

        private List<ExerciseDataStub> _listStub = null;

        public List<ExerciseDataStub> ExerciseData
        {
            get
            {
                if (_listStub == null)
                {
                    _listStub = new List<ExerciseDataStub>();
                }

                return _listStub;
            }
        }

        private XslCompiledTransform _XslCompiledTransform = null;
        public GExerciseData_Auxyliary(ZSBELearning BLP, BL.ZSBELearning.ContextParam ContextParam,XslCompiledTransform XslCompiledTransform)
            : base(BLP, ContextParam)
        {
            _XslCompiledTransform = XslCompiledTransform;
        }

        public void Load()
        {
            switch (ContextParam.AuxyliaryPages)
            {
                case BL.Dictionary.AuxyliaryPagesType.Error: 
                        PlainText(ContextParam, _XslCompiledTransform,false); 
                        break;

                case BL.Dictionary.AuxyliaryPagesType.Fraud:
                        PlainText(ContextParam, _XslCompiledTransform, false); 
                        break;

                case BL.Dictionary.AuxyliaryPagesType.NoAccess:
                        PlainText(ContextParam, _XslCompiledTransform, true); 
                        break;

                case BL.Dictionary.AuxyliaryPagesType.NoExercises:
                        PlainText(ContextParam, _XslCompiledTransform, false); 
                        break;

                case BL.Dictionary.AuxyliaryPagesType.Redirect:
                        PlainText(ContextParam, _XslCompiledTransform, true); 
                        break;

                case BL.Dictionary.AuxyliaryPagesType.StartSummary: 
                        Summary(ContextParam, _XslCompiledTransform); 
                        break;

                case BL.Dictionary.AuxyliaryPagesType.Summary: 
                        Summary(ContextParam, _XslCompiledTransform); 
                        break;
            }
        }

        public void Check(List<GExerciseDataCheckOne> ListExerciseDataSave)
        {
        }

        private void PlainText(BL.ZSBELearning.ContextParam ContextParam, XslCompiledTransform XslCompiledTransform,bool IsValidContex)
        {
            int _stubIndex = 1;

            XmlDocument _xmlDocument = Gemini.Utility.XML.Document.New("Data");
            Gemini.Utility.XML.Attribute.Add(_xmlDocument, _xmlDocument.DocumentElement, "exerciseType", (int)ContextParam.AuxyliaryPages);

            ExerciseDataStub _loopStub = new ExerciseDataStub();
            _loopStub.id = _stubIndex;
            _loopStub.text = RemoveXMLDeclaration(Gemini.Utility.XSL.TransformToText(XslCompiledTransform, _xmlDocument));

            if (IsValidContex == true && ContextParam.ValidContext != null && ContextParam.ValidContext.Course != null)
            {
                _loopStub.suggested_context_id = ContextParam.ValidContext.ContextObjectID;
                _loopStub.suggested_course_id = ContextParam.ValidContext.Course.ID.Value;
            }

            ExerciseData.Add(_loopStub);
        }

        private void Summary(BL.ZSBELearning.ContextParam ContextParam, XslCompiledTransform XslCompiledTransform)
        {
            XmlDocument _xmlDocument = BLP.Exercise.Render.SummaryPage(ContextParam);

            Gemini.Utility.XML.Attribute.Add(_xmlDocument, _xmlDocument.DocumentElement, "courseType", (int)ContextParam.CourseType);
            Gemini.Utility.XML.Attribute.Add(_xmlDocument, _xmlDocument.DocumentElement, "exerciseType", (int)ContextParam.AuxyliaryPages);

            int _stubIndex = 1;


            ExerciseDataStub _loopStub = new ExerciseDataStub();
            _loopStub.id = _stubIndex;
            _loopStub.text = RemoveXMLDeclaration(Gemini.Utility.XSL.TransformToText(XslCompiledTransform, _xmlDocument));

            if (ContextParam.ValidContext != null && ContextParam.ValidContext.Course != null)
            {
                _loopStub.suggested_context_id = ContextParam.ValidContext.ContextObjectID;
                _loopStub.suggested_course_id = ContextParam.ValidContext.Course.ID.Value;
            }


            ExerciseData.Add(_loopStub);
        }

        private string RemoveXMLDeclaration(string Value)
        {
            return Value.Replace("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"><ComponentXML><content><Result>", string.Empty).Replace("</Result></content></ComponentXML>", string.Empty);
        }
    }
}
